import { Briefcase, Mail, Phone, MapPin, Linkedin, Twitter, Facebook } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer">
      <div className="container">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <Briefcase size={36} strokeWidth={2.5} className="footer-logo-icon" />
              <span className="footer-logo-text">CareerConsult</span>
            </div>
            <p className="footer-description">
              Профессиональные консультации по карьере. Помогаем достичь ваших профессиональных целей.
            </p>
            <div className="footer-social">
              <a href="#" className="social-link" aria-label="LinkedIn">
                <Linkedin size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link" aria-label="Twitter">
                <Twitter size={20} strokeWidth={2} />
              </a>
              <a href="#" className="social-link" aria-label="Facebook">
                <Facebook size={20} strokeWidth={2} />
              </a>
            </div>
          </div>
          
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <ul className="footer-links">
              <li>
                <Mail size={18} strokeWidth={2} />
                <a href="mailto:info@careerconsult.ru">info@careerconsult.ru</a>
              </li>
              <li>
                <Phone size={18} strokeWidth={2} />
                <a href="tel:+78001234567">+7 (800) 123-45-67</a>
              </li>
              <li>
                <MapPin size={18} strokeWidth={2} />
                <span>Москва, ул. Профессиональная, 15</span>
              </li>
            </ul>
          </div>
          
          <div className="footer-section">
            <h3 className="footer-title">Услуги</h3>
            <ul className="footer-links">
              <li><a href="#">Резюме и сопроводительные письма</a></li>
              <li><a href="#">Подготовка к собеседованию</a></li>
              <li><a href="#">Смена профессии</a></li>
              <li><a href="#">Карьерный коучинг</a></li>
            </ul>
          </div>
        </div>
        
        <div className="footer-bottom">
          <p>&copy; 2025 CareerConsult. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

